<?php
/**
* @version		$Id:contient.php 1 2014-06-03 15:15:53Z exlineo $
* @package		Exlineo
* @subpackage 	Views
* @copyright	Copyright (C) 2014, exlineo. All rights reserved.
* @license #http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');

 
class ExlineoViewcontients  extends JViewLegacy {


	protected $items;

	protected $pagination;

	protected $state;
	
	
	/**
	 *  Displays the list view
 	 * @param string $tpl   
     */
	public function display($tpl = null)
	{
		
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		ExlineoHelper::addSubmenu('contients');

		$this->addToolbar();
		if(!version_compare(JVERSION,'3','<')){
			$this->sidebar = JHtmlSidebar::render();
		}
		
		if(version_compare(JVERSION,'3','<')){
			$tpl = "25";
		}
		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 */
	protected function addToolbar()
	{
		
		$canDo = ExlineoHelper::getActions();
		$user = JFactory::getUser();
		JToolBarHelper::title( JText::_( 'Contient' ), 'generic.png' );
		if ($canDo->get('core.create')) {
			JToolBarHelper::addNew('contient.add');
		}	
		
		if (($canDo->get('core.edit')))
		{
			JToolBarHelper::editList('contient.edit');
		}
		
				
				

		if ($canDo->get('core.delete'))
		{
			JToolbarHelper::deleteList('', 'contients.delete', 'JTOOLBAR_EMPTY_TRASH');
		}
				
		
		JToolBarHelper::preferences('com_exlineo', '550');  
		if(!version_compare(JVERSION,'3','<')){		
			JHtmlSidebar::setAction('index.php?option=com_exlineo&view=contients');
		}
				
					
	}	
	

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 */
	protected function getSortFields()
	{
		return array(
		 	          'a.id_record' => JText::_('Id_record'),
	     		);
	}	
}
?>
