<?php
/**
* @version		$Id:record.php 1 2014-06-03 15:15:53Z exlineo $
* @package		Exlineo
* @subpackage 	Views
* @copyright	Copyright (C) 2014, exlineo. All rights reserved.
* @license #http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');

 
class ExlineoViewrecherche  extends JViewLegacy {


	protected $items;

	protected $pagination;

	protected $state;
	
	
	/**
	 *  Displays the list view
 	 * @param string $tpl   
     */
	public function display($tpl = null)
	{
		
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		ExlineoHelper::addSubmenu('records');

		$this->addToolbar();
		if(!version_compare(JVERSION,'3','<')){
			$this->sidebar = JHtmlSidebar::render();
		}
		
		if(version_compare(JVERSION,'3','<')){
			$tpl = "25";
		}
		parent::display($tpl);
	}
	
	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 */
	protected function addToolbar()
	{
		
		$canDo = ExlineoHelper::getActions();
		$user = JFactory::getUser();
		JToolBarHelper::title( JText::_( 'Record' ), 'generic.png' );
		if ($canDo->get('core.create')) {
			JToolBarHelper::addNew('record.add');
		}	
		
		if (($canDo->get('core.edit')))
		{
			JToolBarHelper::editList('record.edit');
		}
		
				
		if ($this->state->get('filter.state') != 2)
		{
			JToolbarHelper::publish('records.publish', 'JTOOLBAR_PUBLISH', true);
			JToolbarHelper::unpublish('records.unpublish', 'JTOOLBAR_UNPUBLISH', true);
		}
				
		if ($canDo->get('core.edit.state'))
		{
			if ($this->state->get('filter.state') != -1)
			{
				if ($this->state->get('filter.state') != 2)
				{
					JToolbarHelper::archiveList('records.archive');
				}
				elseif ($this->state->get('filter.state') == 2)
				{
					JToolbarHelper::unarchiveList('records.publish');
				}
			}
			
		}
				
				

		if ($this->state->get('filter.state') == -2 && $canDo->get('core.delete'))
		{
			JToolbarHelper::deleteList('', 'records.delete', 'JTOOLBAR_EMPTY_TRASH');
		}
				elseif ($canDo->get('core.edit.state'))
		{
			JToolbarHelper::trash('records.trash');
		}		
				
		
		JToolBarHelper::preferences('com_exlineo', '550');  
		if(!version_compare(JVERSION,'3','<')){		
			JHtmlSidebar::setAction('index.php?option=com_exlineo&view=records');
		}
				if(!version_compare(JVERSION,'3','<')){
			JHtmlSidebar::addFilter(
				JText::_('JOPTION_SELECT_PUBLISHED'),
				'filter_state',
				JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.state'), true)
			);
		}
				
					
	}	
	

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 */
	protected function getSortFields()
	{
		return array(
		 	          'a.title' => JText::_('Title'),
	     	          'a.alias' => JText::_('Alias'),
	     	          'a.creator' => JText::_('Creator'),
	     	          'a.subject' => JText::_('Subject'),
	     	          'a.publisher' => JText::_('Publisher'),
	     	          'a.contributor' => JText::_('Contributor'),
	     	          'a.date' => JText::_('Date'),
	     	          'a.type' => JText::_('Type'),
	     	          'a.format' => JText::_('Format'),
	     	          'a.source' => JText::_('Source'),
	     	          'a.coverage' => JText::_('Coverage'),
	     	          'a.rights' => JText::_('Rights'),
	     	          'a.id_header' => JText::_('Id_header'),
	     	          'a.record_langage' => JText::_('Record_langage'),
	     	          'a.metadata' => JText::_('Metadata'),
	     	          'a.unique_identifier' => JText::_('Unique_identifier'),
	     	          'a.published' => JText::_('JSTATUS'),
	     	          'a.id_record' => JText::_('Id_record'),
	     		);
	}	
}
?>
