﻿package org.silexlabs.amfphp.clientgenerator.generated.ui
{
	import fla.Label;
	import fla.Button;
	import fla.TextInput;
	import fla.TextResultDisplay;
	
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.net.NetConnection;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFieldType;
	
	import org.silexlabs.amfphp.clientgenerator.NetConnectionSingleton;
	import org.silexlabs.amfphp.clientgenerator.generated.ObjectUtil;
	import org.silexlabs.amfphp.clientgenerator.generated.service.ExampleServiceClient;
	import org.silexlabs.amfphp.clientgenerator.ui.elements.IDataIoGui;
	import org.silexlabs.amfphp.clientgenerator.ui.elements.ILabel;
	
	public class ExampleServiceClientUi extends MovieClip
	{
		/**
		 * layout constants
		 * */
		private static const PADDING:int = 20;
		private static const METHOD_UI_HEIGHT:int = 40;
		private static const METHOD_INPUT_WIDTH:int = 120;
		private static const CALL_BUTTON_X:int = 400;
		
		private var _service:ExampleServiceClient;
		
		
		//returnOneParam inputs 
		public var returnOneParam_param_Input:IDataIoGui; 
		public var returnOneParamLabel:ILabel;
		public var returnOneParam_callButton:ILabel;		
		public var resultDisplay:IDataIoGui;
		public function ExampleServiceClientUi()
		{
			super();

			var xLayoutMultiplier:int = 0;
			var yLayoutMultiplier:int = 0;
			var maxNumMethodInputs:int = 0;
			
			_service = new ExampleServiceClient(NetConnectionSingleton.getNetConnection());
			graphics.beginFill(0, 0.3);
			
			//returnOneParam ui
			xLayoutMultiplier = 0;
			if(!returnOneParamLabel){
				returnOneParamLabel = new Label();
				returnOneParamLabel.label = 'returnOneParam method';
				returnOneParamLabel.displayObject.x = PADDING;
				returnOneParamLabel.displayObject.y = PADDING + METHOD_UI_HEIGHT * yLayoutMultiplier;
				addChild(returnOneParamLabel.displayObject);
				
			}
			
			
			if(!returnOneParam_param_Input){
				returnOneParam_param_Input = new TextInput();
				returnOneParam_param_Input.displayObject.x = PADDING + METHOD_INPUT_WIDTH * xLayoutMultiplier;
				returnOneParam_param_Input.displayObject.y = PADDING + returnOneParamLabel.displayObject.height  + METHOD_UI_HEIGHT * yLayoutMultiplier;
				addChild(returnOneParam_param_Input.displayObject);
				
			}
			xLayoutMultiplier++;
			
			
			if(!returnOneParam_callButton){
				returnOneParam_callButton = new Button();
				returnOneParam_callButton.label = "call";
				returnOneParam_callButton.displayObject.x = PADDING + METHOD_INPUT_WIDTH * xLayoutMultiplier;
				returnOneParam_callButton.displayObject.y = PADDING + returnOneParamLabel.displayObject.height  + METHOD_UI_HEIGHT * yLayoutMultiplier;
				addChild(returnOneParam_callButton.displayObject);
			}
			returnOneParam_callButton.addEventListener(MouseEvent.CLICK, returnOneParam_callButtonClickHandler);
			yLayoutMultiplier++;
			
			if(!resultDisplay){
				resultDisplay = new TextResultDisplay();
				resultDisplay.displayObject.y = 2 * PADDING + METHOD_UI_HEIGHT * yLayoutMultiplier;
				addChild(resultDisplay.displayObject);
			}
			
		}

	  
				
		
		private function returnOneParam_callButtonClickHandler(event:MouseEvent):void{
			_service.returnOneParam(returnOneParam_param_Input.data).setResultHandler(returnOneParamResultHandler).setErrorHandler(errorHandler); 
		}

		private function returnOneParamResultHandler(obj:Object):void{
			resultDisplay.data = "result : \n" + obj + '\n' + ObjectUtil.deepObjectToString(obj) + "\n";
		}
		
		
		private function errorHandler(obj:Object):void{
			resultDisplay.data = "error :  \n" +  ObjectUtil.deepObjectToString(obj) + "\n";
		}
	}
}